/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DesignAlsXMLAgent extends AgentBase {

	public void NotesMain() {
		NoteCollection nc = null;
		DxlExporter exporter = null;
		Document doc = null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();

			Database database = agentContext.getCurrentDatabase();
			nc = database.createNoteCollection(false);
			nc.selectAllDesignElements(true);
			nc.buildCollection();

			exporter = session.createDxlExporter();
			doc = database.createDocument();
			doc.replaceItemValue("Form", "FO_Report");

			RichTextItem rt = doc.createRichTextItem("Body");
			String result = exporter.exportDxl(nc);
			niceAppend (rt, result);
			doc.replaceItemValue(
				"F_Titel",
				"Alle Design Elemente dieser Datenbank als XML");
			doc.save(true, false);
		} catch (NotesException e) {
			e.printStackTrace();
		} finally {
			try {
				if (nc != null) {nc.recycle();}
				if (exporter != null) {
					System.out.println (exporter.getLog());
					exporter.recycle();
				}
				if (doc != null) {doc.recycle();}
			} catch (NotesException e1) {
				e1.printStackTrace();
			}
		}
	}
	/**
	 * Formatiert den String s, von dem Erwartet wird, dass er XML enthlt
	 * und speichert ihn im RichText Item rt.
	 * 
	 * @param rt - RichText Item in das der String s eingefgt werden soll.
	 * @param s - Einzufgender String
	 * @throws NotesException
	 */
	private static void niceAppend(RichTextItem rt, String s) throws NotesException {
		char[] ca = s.toCharArray();
		StringBuffer line = new StringBuffer();
		for (int i = 0, l = ca.length; i < l - 1; i++) {
			line.append(ca[i]);
			if (ca[i] == '<' && ca[i + 1] == '/') {
				while (i < l - 1) {
						i += 1;
						line.append(ca[i]);
						if (ca[i] == '>') {
							rt.appendText(line.toString());
							rt.addNewLine(1);
							line = new StringBuffer();
						}
				}
			}
		}
		rt.appendText("" + ca[ca.length - 1]);
	}
}